class MutAgedToPerfection extends Mutator
	config(AgedToPerfection);

var config bool bDoneGoneBad;
var config int startHealth;
var config int healthStep;
var config int ageFreq;
var config float badChance;

var localized string poisonText;
var localized string startText;
var localized string stepText;
var localized string ageFreqText;
var localized string chanceText;

function bool CheckReplacement( Actor Other, out byte bSuperRelevant ) {
	bSuperRelevant = 0;
	if ( String(Other.class) == "XPickups.MiniHealthPack") {
		ReplaceWith( Other, "AgedToPerfection.AgedHealthVial");
		return false;
	}
	return true;
}

static function FillPlayInfo(PlayInfo PlayInfo) {
	Super.FillPlayInfo(PlayInfo);
	PlayInfo.AddSetting(default.RulesGroup, "bDoneGoneBad", default.poisonText, 0, 4, "Check");
	PlayInfo.AddSetting(default.RulesGroup, "badChance", default.chanceText, 0, 5, "Text", "8;0.00:1.00");
	PlayInfo.AddSetting(default.RulesGroup, "startHealth", default.startText, 0, 1, "Text", "8;0:50");
	PlayInfo.AddSetting(default.RulesGroup, "healthStep", default.stepText, 0, 2, "Text", "8;0:50");
	PlayInfo.AddSetting(default.RulesGroup, "ageFreq", default.ageFreqText, 0, 3, "Text", "8;1:120");
}

static event string GetDescriptionText(string PropName) {
	if ( PropName == "bDoneGoneBad" ) {
		return default.poisonText;
	}
	return Super.GetDescriptionText(PropName);
}

defaultproperties
{
     GroupName="HealthVial"
     FriendlyName="Aged To Perfection"
     Description="Aged Health Vials are better for you"
     poisonText="Allow the vials to go bad"
     startText="Base healing amount"
     stepText="Healing change per step"
     ageFreqText="Seconds per aging step"
     chanceText="Chance a vial will go bad"
     bDoneGoneBad=false
     startHealth=5
     healthStep=5
     ageFreq=30
     badChance=0.1
}
